#define MAXRSB	20000
#define MAXSUB	5000
#include <stdlib>
#include <stdio>
#include <ssdef>
#include <syidef>
#include <dvidef>
#include <lib$routines>
#include <starlet>
#include <errno>
#include <string>
#include <str$routines>
#include <descrip>

typedef struct {
	unsigned char	resnam_len;
	unsigned char	resnam[31];
	unsigned long	csid;
	unsigned long	subrsbcnt;
	unsigned long	total_activity, total_nact, total_oact, total_lckcnt;
	void	*addr;
	} RSBENTRY ;

RSBENTRY rsbs[MAXRSB];
long	rsb_cnt = 0;
enum {OK, UNK_STOP, LCK_ROOT, SUB_LOST, ROOT_LOST, TOO_MANY_RRSB, TOO_MANY_SRSB}
		why_stop=OK;
char *why_stop_desc[] = {"OK", "Unknown", "OK", "Lost subresource chain",
	"Lost root RSB chain", "Too many RRSB", "Too many SRSB"};

int count_activity (void);
int  compare_rsbentry (const void *a, const void *b);
void get_device_name (struct dsc$descriptor_d *output,
		const unsigned char *in_devlocknam, long in_devlocknam_len);

#if !MAIN
long main (int argc, char **argx) {
	long rsb_chain (int argc, char **argx);
	rsb_chain (argc, argx);
}
#endif

long rsb_chain (int argc, char **argx) {
	register long sts, i, ii, inc, maxdisp=0;

	/*how may resources to display*/
	if (argc > 1) maxdisp = atol(argx[1]);
	if (maxdisp == 0) maxdisp = 10;

	/*get resource information*/
	sts = sys$cmexec (count_activity, 0);
	if (!(sts&1)) {
		perror(strerror(EVMSERR, sts));
		exit (sts);
		}

/*	for debug; find a particular rsb and put it at the top of the qsort */
/*	for (i=0; i < rsb_cnt; i++) rsbs[i].total_oact =
/*		((long)rsbs[i].addr==0x8ad9d900) ? 99999 : rsbs[i].total_oact;
*/

	qsort(rsbs, rsb_cnt, sizeof (RSBENTRY), compare_rsbentry);

	inc = 1;
	for ( i=ii=0; ii<rsb_cnt && ii<maxdisp ; i+=inc +0*ii++) {
		/*inc ==  1 means report local locking
		/*inc == -1 means report distributed locking
		/*i is index into rsb[]
		/*ii is the report line number. */
#if look_at_sub_rsbs
		$DESCRIPTOR(ctlstr,   "!80<!32AF !6AS !3(7UL) !5UL !4UL !8XL!>   !AS");
		$DESCRIPTOR(ctlstr_h,     "!32AF !6AZ !3(7AZ) !5AZ !4AZ !8AZ");
#else
		$DESCRIPTOR(ctlstr,   "!80<!32AF !6AS !3(7UL) !0UL!0UL!8XL!>   !AS");
		$DESCRIPTOR(ctlstr_h,     "!32AF !6AZ !3(7AZ) !0AZ!0AZ!8AZ");
#endif
		struct dsc$descriptor_d
			filename={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
			devname ={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
			nodename ={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
			outbufx ={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
			tmp1_dx ={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};
		long sts, tmp;

		/*Do local locking, then do distributed locking
		/*Distributed locking is stored from rsb_cnt to the middle.
		/*Local locking is stored from 0 to the middle.
		/*Switch from local locking to distributed locking when we
		/*run out of local locks, or half way through the report.*/
		if (inc>0 &&
		   ((rsbs[i].csid!=0) || (ii >= maxdisp/2))) {
			inc = -1;
			i=rsb_cnt -1;
			printf("\n");
			printf("--distributed locks--\n");
			}
		if (inc<0 && rsbs[i].csid==0) {
			/*stop reporting distributed*/
			ii = rsb_cnt;
			break;
			}

		/*display headers*/
		if (i==0) {
			lib$sys_fao(&ctlstr_h, 0, &outbufx,
				13, "Resource name", "CSID  ",
				"    Oact","    Nact","    Act", "locks","srsb",
				" RSBaddr");
			lib$put_output(&outbufx);
			}

		/*copy resource name */
		tmp = rsbs[i].resnam_len;
/*		str$copy_r(&filename, &tmp, &rsbs[i].resnam);*/

		/*If an RMS resource, display filename*/
		if (strncmp("RMS$", (char *)(&rsbs[i].resnam), 4) == 0) {
			/*try using device name from lock resource name*/
			get_device_name (&devname, &rsbs[i].resnam[10], 
				rsbs[i].resnam_len -10);
			sts = lib$fid_to_name( &devname, &rsbs[i].resnam[4],
				&filename);
			if (!(sts&1))
				lib$sys_fao(" unknown RMS lock", 0, &filename);
			}

		/*If an RDB resource, display filename Y...D...*/
		if ( *(long *)(&rsbs[i].resnam[0]) == 0xdd &&
		     *(long *)(&rsbs[i].resnam[4]) == 0x44) {
			/*try using device name from lock resource name*/
			get_device_name (&devname, &rsbs[i].resnam[8], 16);
			sts = lib$fid_to_name( &devname, &rsbs[i].resnam[22],
				&filename);
			}

		/*Unknown RDB resource, Y...T...*/
		if ( *(long *)(&rsbs[i].resnam[0]) == 0xdd &&
		     *(long *)(&rsbs[i].resnam[4]) == 0x54) {
			sts = str$copy_r(&filename, &13, " ? rdb lock ?");
			}

		/*If an RDB resource, display filename Y.D*/
		if ( rsbs[i].resnam[0] == 0xdd  &&
		     rsbs[i].resnam[1] == 0x00  &&
		     rsbs[i].resnam[2] == 0x44) {
			/*try using device name from lock resource name*/
			get_device_name (&devname, &rsbs[i].resnam[3], 16);
			sts = lib$fid_to_name( &devname, &rsbs[i].resnam[19],
				&filename);
			}

		/*Unknown RDB resource, Y.T.*/
		if ( rsbs[i].resnam[0] == 0xdd &&
		     rsbs[i].resnam[1] == 0x00 &&
		     rsbs[i].resnam[2] == 0x54) {
			sts = str$copy_r(&filename, &13, " ? rdb lock ?");
			}

		/*Files 11 volume lock (F11B$V...)*/
		if ( strncmp((char *)(&rsbs[i].resnam), "F11B$v", 6) == 0) {
			$DESCRIPTOR(ctlstr, " files-11 volume lock : !AF");
			sts = lib$sys_fao( &ctlstr,
				0, &filename, 12, &rsbs[i].resnam[6]);
			}
		else
		/*Other files 11 locks (F11B$...)*/
		if ( strncmp((char *)(&rsbs[i].resnam), "F11B$", 5) == 0) {
			$DESCRIPTOR(ctlstr, "files-11 lock : !AF");
			sts = lib$sys_fao(&ctlstr,
				0, &filename, 12, &rsbs[i].resnam[6]);
			}

		/*display resource information*/
		tmp = rsbs[i].csid;
		sts = lib$getsyi(&SYI$_NODENAME, 0, &nodename, 0, &tmp, 0);
		if (!(sts&1)) lib$signal(sts);
		sts = lib$sys_fao(&ctlstr, 0, &outbufx,
			rsbs[i].resnam_len,
			rsbs[i].resnam,
			&nodename,
			rsbs[i].total_oact,
			rsbs[i].total_nact,
			rsbs[i].total_activity,
			rsbs[i].total_lckcnt,
			rsbs[i].subrsbcnt,
			rsbs[i].addr,
			&filename);
		if (!(sts&1)) lib$signal(sts);
		sts = lib$put_output(&outbufx);
		if (!(sts&1)) lib$signal(sts);
		}

	{
		/*Print summary lines*/
		double total_oact_d=0, total_nact_d=0;
		for (i=0; i<rsb_cnt ; i++) {
			total_oact_d += rsbs[i].total_oact;
			total_nact_d += rsbs[i].total_nact;
			}
		printf("%21s TOTAL_OLD_ACT=%7g  TOTAL_NEW_ACT=%7g\n",
			"Total locking: ", total_oact_d, total_nact_d);

		total_nact_d=total_oact_d=0; 
		for (i=0; i<rsb_cnt && rsbs[i].csid==0 ; i++) {
			total_oact_d += rsbs[i].total_oact;
			total_nact_d += rsbs[i].total_nact;
			}
		printf("%21s TOTAL_OLD_ACT=%7g  TOTAL_NEW_ACT=%7g\n",
			"Total local locking: ", total_oact_d, total_nact_d);

		total_nact_d=total_oact_d=0; 
		for (i=rsb_cnt -1; i>=0 && rsbs[i].csid!=0 ; i--) {
			total_oact_d += rsbs[i].total_oact;
			total_nact_d += rsbs[i].total_nact;
			}
		printf("%21s TOTAL_OLD_ACT=%7g  TOTAL_NEW_ACT=%7g\n",
			"Distributed locking: ", total_oact_d, total_nact_d);

		printf("Completion status: %s", why_stop_desc[why_stop]);
	}

	return 1;
}

void get_device_name (struct dsc$descriptor_d *output,
		const unsigned char *in_devlocknam, long in_devlocknam_len) {
	struct dsc$descriptor_d
		tmp1_dx ={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};
	static char devlocknam[32];
	static long devlocknam_len;
	static struct {short bufsiz;short itmcode; void *bufadr; void *retlen;}
		itmlst[2]={32, DVI$_DEVLOCKNAM, &devlocknam, &devlocknam_len,
		            0,0,0,0};

	register long sts, i;
	long tmp;

	/*Perhaps the device lock name contains a valid logical name */
	tmp = in_devlocknam_len - 1 - 3;
	str$copy_r(output, &tmp, &in_devlocknam[1]);
	str$trim(output, output);	/*remove spaces*/
	sts = sys$getdvi(0, 0, output, &itmlst, 0, 0, 0, 0);
	if (sts&1  &&  devlocknam_len != in_devlocknam_len) sts = 0;
	if (sts&1) sts = !memcmp(&devlocknam, in_devlocknam, devlocknam_len -3);

	if (!(sts&1)) {
		/*try adding 'DISK$' to the device name */
		str$copy_r(&tmp1_dx, &5, "DISK$");
		str$append(&tmp1_dx, output);
		str$copy_dx(output, &tmp1_dx);
		sts = sys$getdvi(0, 0, output, &itmlst, 0, 0, 0, 0);
		if (sts&1  &&  devlocknam_len != in_devlocknam_len) sts = 0;
		if (sts&1)sts=!memcmp(&devlocknam,in_devlocknam,devlocknam_len);
		}

	/*This is not a valid device lock name.  Give up.*/
	if (!(sts&1)) sts = str$copy_r(output, &0, &0);

}	

int  compare_rsbentry (const void *a, const void *b) {
	register const RSBENTRY *a_rsb = a;
	register long a_val = ((RSBENTRY *)a)->total_oact;
	register long b_val = ((RSBENTRY *)b)->total_oact;
	a_val = ((RSBENTRY *)a)->csid? -2*a_val -1: 2*a_val;
	b_val = ((RSBENTRY *)b)->csid? -2*b_val -1: 2*b_val;
	return b_val - a_val;
}

#if defined(__DECC) || defined(__DECCXX)
# pragma extern_model __save
# pragma extern_model globalvalue
	extern void *LCK$GL_RRSFL;
	extern long RSB$L_RRSFL, RSB$L_SRSFL;
	extern long RSB$W_ACTIVITY, RSB$W_NACT, RSB$W_OACT, RSB$L_CSID;
	extern long RSB$W_LCKCNT;
	extern long RSB$B_RSNLEN, RSB$T_RESNAM;
# pragma extern_model __restore
#else
	globalvalue void (*LCK$GL_RRSFL);
	globalvalue long RSB$L_RRSFL, RSB$L_SRSFL;
	globalvalue long RSB$W_ACTIVITY, RSB$W_NACT, RSB$W_OACT, RSB$L_CSID;
	globalvalue long RSB$B_RSNLEN, RSB$T_RESNAM;
#endif

int count_activity (void) {
	static void **current_rrsb, **parent_srsb, **current_srsb;
	static char *rsb, *p;

	current_rrsb= *(void **)LCK$GL_RRSFL;
	for (; why_stop!=UNK_STOP;
			current_rrsb = *current_rrsb) {
		if (current_rrsb==0) {
			why_stop = ROOT_LOST;
			break;};
		if (current_rrsb==(void **)LCK$GL_RRSFL) {
			why_stop = LCK_ROOT;
			break;};
		rsb = (char *)current_rrsb - RSB$L_RRSFL;
		rsbs[rsb_cnt].addr = rsb;

		p = rsb + RSB$B_RSNLEN;
		memcpy(&rsbs[rsb_cnt].resnam_len, p, 32);
		p = rsb + RSB$L_CSID;
		rsbs[rsb_cnt].csid = *(long *)p;
		p = rsb + RSB$L_CSID;

		rsbs[rsb_cnt].subrsbcnt 	= 0;

		p = rsb + RSB$W_ACTIVITY;
		rsbs[rsb_cnt].total_activity	= *(unsigned short *)p;
		p = rsb + RSB$W_NACT;
		rsbs[rsb_cnt].total_nact	= *(unsigned short *)p;
		p = rsb + RSB$W_OACT;
		rsbs[rsb_cnt].total_oact	= *(unsigned short *)p;
		p = rsb + RSB$W_LCKCNT;
		rsbs[rsb_cnt].total_lckcnt	= *(unsigned short *)p;

#if look_at_sub_rsbs
		parent_srsb = (void *)(rsb + RSB$L_SRSFL);
		for (current_srsb = *parent_srsb; current_srsb != parent_srsb; 
			current_srsb = *current_srsb) {
			if (current_srsb==0) {
			char *rsb;
				why_stop = SUB_LOST;
				current_srsb = parent_srsb;
				break;};
			rsb = (char *)current_srsb - RSB$L_SRSFL;

/*			p = rsb + RSB$W_ACTIVITY;
/*			rsbs[rsb_cnt].total_activity	+= *(unsigned short *)p;
/*			p = rsb + RSB$W_NACT;
/*			rsbs[rsb_cnt].total_nact	+= *(unsigned short *)p;
/*			p = rsb + RSB$W_OACT;
/*			rsbs[rsb_cnt].total_oact	+= *(unsigned short *)p;
*/
			p = rsb + RSB$W_LCKCNT;
			rsbs[rsb_cnt].total_lckcnt	+= *(unsigned short *)p;
			rsbs[rsb_cnt].subrsbcnt++;
			if (rsbs[rsb_cnt].subrsbcnt > MAXSUB) {
				why_stop = TOO_MANY_SRSB;
				current_srsb = parent_srsb;
				break;};
			}
#endif

		rsb_cnt++;
		if (rsb_cnt >= MAXRSB || rsb_cnt < 0) {
			why_stop = TOO_MANY_RRSB;
			break;};
		}

	return 1;
}
